@extends('layouts.master')

@section('title')
    لوحة التحكم
@endsection

@section('first-css')
@endsection

@section('content-body')
    <!--**********************************
                        Content body start
                    ***********************************-->
    @include('massages')
    @if (Auth::user()->role == 0)
        @include('admin.dashboard')
    @elseif(Auth::user()->role == 1)
        @include('trainer.dashboard')
    @else
        <!--**********************************
                        Content body end
                    ***********************************-->


        <div class="container">
            <div class="" style="min-height: 828px;">
                <div class="container-fluid">
                    <div class="row">
                        @isset($appendixes)
                            @foreach ($appendixes as $appendix)
                            @isset($appendix)
                            <div class="col-xl-6 col-lg-6 col-md-6">
                                <div class="card bg-info">
                                    
                                    <div class="card-body mb-0">
                                        <p class="card-text text-white">@isset($appendix->description)
                                            {{$appendix->description}}
                                        @endisset</p>
                                            <a href="{{route('appendix_download',$appendix->id)}}" class="btn bg-white text-info btn-card">تنزيل</a>
                                    </div>
                                    
                                </div>
                            </div>
                            @endisset
                            @endforeach
                        @endisset
                    </div>
                </div>
            </div>

        </div>
    @endif
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            $('table.display').DataTable();
        });
    </script>
    <script src="{{ asset('/vendor/datatables/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('/js/plugins-init/datatables.init.js') }}"></script>
@endsection
